/*========================================================
 * SD memory card client function header file for Linux-OS
 *
 * Copyright (c) 2002-2008 Matsushita Electric Industrial Co., Ltd.
 * All Rights Reserved.
 * Copyright (c) 2008-2009 Panasonic Corporation
 * All Rights Reserved.
 *
 * Last update: 2009/06/08
 *========================================================*/

#ifndef __MEM_MAIN_H__
#define __MEM_MAIN_H__

/************************************************************/
/* o[W                                           */
/************************************************************/
#define VERSION_INFO		0x05	/* 2005.07.06 */


/************************************************************/
/* }N`                                               */
/************************************************************/
#define SD_MEMORY_MAJOR		(SD_CS_MAJOR_BASE+SD_MAJOR_MEM)
#define SD_MEMORY_MINOR		1
#define SECTOR_SIZE		512


/***********************************************************/
/* e萔̒`                                          */
/***********************************************************/
#define MAJOR_NR SD_MEMORY_MAJOR
#define DEVICE_NR(device) MINOR(device)
#define DEVICE_NAME "sdmem"
#define DEVICE_REQUEST MEMORY_F_Request


/************************************************************/
/* SDNCAghCopCN[h               */
/* ȊOɂgp邪Ainclude/sd_api.hŒ`ς       */
/************************************************************/
#include <linux/errno.h>
#include <linux/blkdev.h>
#include <linux/genhd.h>


/************************************************************/
/* O[oϐ                                           */
/************************************************************/
typedef struct{
	ULONG		open_cnt;	//I[vJEg
	int			wp_cnt;		//Write Protect`FbNJEg
	int			fd;		//J[hT[rXhCofd
} memory_struct;

static memory_struct MEMORY_DEV;


/***********************************************************/
/* vg^Cv錾                                        */
/***********************************************************/
static int MEMORY_F_Open(struct block_device *blk, fmode_t f_mode);
static int MEMORY_F_Close(struct gendisk *gen, fmode_t f_mode);
static int MEMORY_F_Ioctl(struct block_device *dev, fmode_t f_mode, unsigned cmd, unsigned long arg);


/***********************************************************/
/* hCopϐ                                    */
/***********************************************************/
#define MEM_SHIFT 4
#define MEM_DEVICE_NUM 16

#endif	//__MEM_MAIN_H__
